<?php
  include "includes/header.php";
  include "includes/navigation.php";
?>

  <main class="dispute-container">
    <h1>Terms & Conditions</h1>
    <p class="dispute-subtitle">
      These Terms & Conditions govern the use of the Katika platform.
      By using Katika, you agree to follow these rules.
    </p>

    <div class="dispute-section">
      <h2>1. Introduction & Acceptance</h2>
      <p>
        These Terms & Conditions (“Terms”) govern the use of the Katika website,
        mobile application, and services (“Platform”).
      </p>
      <p>
        By accessing or using the Platform, you confirm that you have read,
        understood, and agreed to these Terms. If you do not agree, you must not
        use the Platform.
      </p>
    </div>

    <div class="dispute-section">
      <h2>2. What Katika Is (And Is Not)</h2>

      <p><strong>What Katika is:</strong></p>
      <ul>
        <li>A transaction protection platform</li>
        <li>A neutral payment controller</li>
        <li>A dispute resolution authority based on rules and evidence</li>
      </ul>

      <p style="margin-top:12px;"><strong>What Katika is NOT:</strong></p>
      <ul>
        <li>A buyer or seller of goods</li>
        <li>A physical inspection service</li>
        <li>A shipping or delivery company</li>
        <li>A guarantor beyond agreed transaction terms</li>
      </ul>

      <p class="dispute-note">
        All transactions are strictly peer-to-peer between users.
      </p>
    </div>

    <div class="dispute-section">
      <h2>3. Eligibility to Use the Platform</h2>
      <ul>
        <li>You must be at least 18 years old</li>
        <li>You must have legal capacity to enter agreements</li>
        <li>You must provide accurate and truthful information</li>
        <li>You must use the Platform only for lawful transactions</li>
      </ul>

      <p class="dispute-warning">
        Providing false information may lead to account suspension or termination.
      </p>
    </div>

    <div class="dispute-section">
      <h2>4. User Responsibilities</h2>

      <p><strong>Buyers agree to:</strong></p>
      <ul>
        <li>Review item details carefully before payment</li>
        <li>Inspect items before confirming delivery</li>
        <li>Open disputes within allowed timeframes</li>
        <li>Provide honest and accurate evidence</li>
      </ul>

      <p style="margin-top:12px;"><strong>Sellers agree to:</strong></p>
      <ul>
        <li>Describe items truthfully and clearly</li>
        <li>Deliver items exactly as agreed</li>
        <li>Provide valid delivery proof</li>
        <li>Cooperate fully during disputes</li>
      </ul>
    </div>

    <div class="dispute-section">
      <h2>5. Payment Handling Rules</h2>
      <p>
        Buyer payments are held securely until transaction conditions are met.
        Funds are released only after buyer confirmation or dispute resolution.
      </p>
      <p>
        No user can manually force a release or withdrawal of funds.
      </p>
    </div>

    <div class="dispute-section">
      <h2>6. Disputes & Resolution</h2>
      <p>
        Disputes are governed by the Official Dispute Resolution Policy,
        which forms part of these Terms.
      </p>
      <p>
        All dispute decisions are based strictly on evidence and platform rules.
        Decisions are final and binding.
      </p>
    </div>

    <div class="dispute-section">
      <h2>7. Returns & Refunds</h2>
      <p>
        Refunds are granted only when approved through dispute resolution.
        Returned items must be sent back with valid proof.
      </p>
      <p class="dispute-note">
        No return = no refund.
      </p>
    </div>

    <div class="dispute-section">
      <h2>8. Prohibited Activities</h2>
      <ul>
        <li>Submitting fake or edited evidence</li>
        <li>Using the Platform for illegal goods or services</li>
        <li>Harassing users or platform staff</li>
        <li>Bypassing payment controls</li>
        <li>Abusing disputes for personal gain</li>
      </ul>

      <p class="dispute-warning">
        Violations may result in suspension, permanent ban, or loss of funds.
      </p>
    </div>

    <div class="dispute-section">
      <h2>9. Fees & Charges</h2>
      <p>
        Dispute opening is currently free.
        The party found at fault may be penalized.
      </p>
      <p>
        Fees may change in the future with prior notice.
      </p>
    </div>

    <div class="dispute-section">
      <h2>10. Account Suspension & Termination</h2>
      <p>
        Katika reserves the right to suspend or terminate accounts involved in
        fraud, abuse, or serious violations.
      </p>
      <p>
        Funds may be frozen during investigations to protect platform integrity.
      </p>
    </div>

    <div class="dispute-section">
      <h2>11. Limitation of Liability</h2>
      <p>
        Katika is not responsible for product quality beyond agreed descriptions,
        shipping delays, courier issues, or losses caused by user negligence.
      </p>
      <p>
        Platform liability is limited strictly to payment control according to these Terms.
      </p>
    </div>

    <div class="dispute-section">
      <h2>12. Platform Authority & Changes</h2>
      <p>
        Katika reserves the right to update these Terms, modify features,
        adjust dispute procedures, or freeze accounts when necessary.
      </p>
      <p>
        Continued use of the Platform after changes constitutes acceptance.
      </p>
    </div>

    <div class="dispute-section">
      <h2>13. Governing Law</h2>
      <p>
        These Terms are governed by applicable laws in Cameroon.
        Any disputes shall be resolved under applicable jurisdiction.
      </p>
    </div>

    <div class="dispute-section">
      <h2>14. Contact & Support</h2>
      <p>
        For questions or concerns, users should contact official support
        channels provided within the Platform.
      </p>
    </div>

  </main>

  <?php
    include "includes/footer.php";
?>
