<?php
  include "includes/header.php";
  include "includes/navigation.php";
?>
  <main class="dispute-container">
    <h1>Privacy Policy</h1>
    <p class="dispute-subtitle">
      This Privacy Policy explains how Katika collects, uses, stores,
      and protects your personal information.
    </p>

    <div class="dispute-section">
      <h2>1. Introduction</h2>
      <p>
        Katika respects your privacy and is committed to protecting your personal data.
        This policy applies to all users of the Katika website and mobile application.
      </p>
    </div>

    <div class="dispute-section">
      <h2>2. Information We Collect</h2>

      <p><strong>Information you provide:</strong></p>
      <ul>
        <li>Name, phone number, and contact details</li>
        <li>Account and profile information</li>
        <li>Transaction details and agreements</li>
        <li>Dispute evidence (photos, videos, messages)</li>
      </ul>

      <p style="margin-top:12px;"><strong>Information collected automatically:</strong></p>
      <ul>
        <li>Device and browser information</li>
        <li>IP address and usage data</li>
        <li>Log and activity records</li>
      </ul>
    </div>

    <div class="dispute-section">
      <h2>3. How We Use Your Information</h2>
      <ul>
        <li>To process and protect transactions</li>
        <li>To manage disputes and resolve issues</li>
        <li>To verify identity and prevent fraud</li>
        <li>To improve platform performance and security</li>
        <li>To communicate important updates</li>
      </ul>

      <p class="dispute-note">
        We use data only for legitimate platform operations.
      </p>
    </div>

    <div class="dispute-section">
      <h2>4. Payment & Transaction Data</h2>
      <p>
        Payment-related data is handled securely.
        Katika does not sell or misuse payment information.
      </p>
      <p>
        Transaction records may be retained for legal, security,
        and dispute resolution purposes.
      </p>
    </div>

    <div class="dispute-section">
      <h2>5. Dispute Evidence & Communication</h2>
      <p>
        Evidence submitted during disputes (photos, videos, messages)
        is used strictly for dispute review and resolution.
      </p>
      <p>
        Such data is accessed only by authorized personnel and is not shared publicly.
      </p>
    </div>

    <div class="dispute-section">
      <h2>6. Data Sharing</h2>
      <p>
        We do not sell your personal data.
      </p>
      <p>
        Data may be shared only when necessary:
      </p>
      <ul>
        <li>To comply with legal obligations</li>
        <li>To prevent fraud or illegal activity</li>
        <li>With trusted service providers under confidentiality</li>
      </ul>
    </div>

    <div class="dispute-section">
      <h2>7. Data Storage & Security</h2>
      <p>
        We implement technical and organizational measures to protect your data
        from unauthorized access, loss, or misuse.
      </p>
      <p>
        Despite safeguards, no system is 100% secure.
        Users are encouraged to protect their account credentials.
      </p>
    </div>

    <div class="dispute-section">
      <h2>8. Data Retention</h2>
      <p>
        Personal data is retained only as long as necessary
        for platform operations, legal compliance, and dispute resolution.
      </p>
    </div>

    <div class="dispute-section">
      <h2>9. Your Rights</h2>
      <p>You have the right to:</p>
      <ul>
        <li>Access your personal information</li>
        <li>Request correction of inaccurate data</li>
        <li>Request deletion where legally permitted</li>
        <li>Withdraw consent where applicable</li>
      </ul>
    </div>

    <div class="dispute-section">
      <h2>10. Cookies & Tracking</h2>
      <p>
        Katika may use cookies or similar technologies
        to improve user experience and platform functionality.
      </p>
      <p>
        You can manage cookie preferences through your browser settings.
      </p>
    </div>

    <div class="dispute-section">
      <h2>11. Children’s Privacy</h2>
      <p>
        Katika is not intended for users under the age of 18.
        We do not knowingly collect data from minors.
      </p>
    </div>

    <div class="dispute-section">
      <h2>12. Changes to This Policy</h2>
      <p>
        This Privacy Policy may be updated from time to time.
        Continued use of the Platform constitutes acceptance of changes.
      </p>
    </div>

    <div class="dispute-section">
      <h2>13. Contact Us</h2>
      <p>
        If you have questions or concerns about this Privacy Policy,
        please contact official support channels provided within the Platform.
      </p>
    </div>

  </main>



<?php
  include "includes/footer.php";
?>