
<?php

  include "includes/header.php" ;
  include "includes/navigation.php" ;


?>

<section class="hero">
  <div class="hero-inner section-inner">
    <div class="reveal">
      <h1>Money Moves Only<br>When the Deal Is Done</h1>
      <p>Katika protects buyers and sellers by holding money safely until goods are delivered or services completed.</p>
      <div class="cta">
        <a href="#download" class="cta-primary">Download App</a>
        <a href="#how" class="cta-secondary">How It Works</a>
      </div>
    </div>
    <img src="assets/img/home.png" alt="Secure payment illustration" class="reveal" />
  </div>
</section>

<section id="why">
  <div class="section-inner reveal">
    <h2>Why People Choose Katika</h2>
    <br>
    <p class="section-desc">
      Buying and selling online should not feel like a gamble. Katika removes uncertainty
      by making sure both buyers and sellers are protected from start to finish.
    </p>
    <br>
    <div class="grid">
      <div class="card">
        <div class="why-icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-shield" viewBox="0 0 16 16">
            <path d="M5.338 1.59a61 61 0 0 0-2.837.856.48.48 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.7 10.7 0 0 0 2.287 2.233c.346.244.652.42.893.533q.18.085.293.118a1 1 0 0 0 .101.025 1 1 0 0 0 .1-.025q.114-.034.294-.118c.24-.113.547-.29.893-.533a10.7 10.7 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.8 11.8 0 0 1-2.517 2.453 7 7 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7 7 0 0 1-1.048-.625 11.8 11.8 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 63 63 0 0 1 5.072.56"/>
          </svg>
        </div>
        <h3>Protection for Buyers</h3>
        <p>
          When you buy online, your money is not sent directly to the seller.
          Katika holds the payment safely until you receive the item and confirm
          that it matches what was agreed.
        </p>
      </div>

      <div class="card">
        <div class="why-icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-lock" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M8 0a4 4 0 0 1 4 4v2.05a2.5 2.5 0 0 1 2 2.45v5a2.5 2.5 0 0 1-2.5 2.5h-7A2.5 2.5 0 0 1 2 13.5v-5a2.5 2.5 0 0 1 2-2.45V4a4 4 0 0 1 4-4M4.5 7A1.5 1.5 0 0 0 3 8.5v5A1.5 1.5 0 0 0 4.5 15h7a1.5 1.5 0 0 0 1.5-1.5v-5A1.5 1.5 0 0 0 11.5 7zM8 1a3 3 0 0 0-3 3v2h6V4a3 3 0 0 0-3-3"/>
          </svg>
        </div>
        <h3>Confidence for Sellers</h3>
        <p>
          Sellers no longer worry about delivering goods and not getting paid.
          With Katika, the buyer’s money is already secured before delivery begins.
        </p>
      </div>

      <div class="card">
        <div class="why-icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-file-earmark-check" viewBox="0 0 16 16">
            <path d="M10.854 7.854a.5.5 0 0 0-.708-.708L7.5 9.793 6.354 8.646a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0z"/>
            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2M9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z"/>
          </svg>
        </div>
        
        <h3>Clear, Agreed Rules</h3>
        <p>
          Every transaction is based on clear terms agreed by both parties upfront.
          No last-minute changes, no misunderstandings, and no hidden conditions.
        </p>
      </div>
    </div>
  </div>
</section>


<section id="how">
  <div class="section-inner">
    <h2>How It Works</h2>
    <p class="section-desc">
      Four simple steps. Clear for buyers. Safe for sellers.
    </p>

    <div class="timeline">
      <div class="timeline-step reveal-left active">
        <span class="step-number">1</span>
        <h3>Agree on the Deal</h3>
        <p>
          Buyer and seller agree on the item, price, and delivery method
          on WhatsApp, Facebook, or Instagram.
        </p>
      </div>

      <div class="timeline-step reveal-up active">
        <span class="step-number">2</span>
        <h3>Buyer Pays via Katika</h3>
        <p>
          The buyer sends payment to Katika. The money is held safely.
        </p>
      </div>

      <div class="timeline-step reveal-up active">
        <span class="step-number">3</span>
        <h3>Seller Delivers</h3>
        <p>
          The seller delivers the item knowing payment is already secured.
        </p>
      </div>

      <div class="timeline-step reveal-right active">
        <span class="step-number">4</span>
        <h3>Money Is Released</h3>
        <p>
          Once the buyer confirms delivery, money is released instantly.
        </p>
      </div>
    </div>
  </div>
</section>

<section id="scenarios">
  <div class="section-inner reveal">
    <h2>Without Katika vs With Katika</h2>

    <div class="scenario-layout">

      <!-- LEFT: Stacked Cards -->
      <div class="scenario-cards">
        <div class="card">
          <h3 class="scenario-title">
            <svg xmlns="http://www.w3.org/2000/svg"
                width="25"
                height="25"
                fill="currentColor"
                class="bi bi-x-circle"
                viewBox="0 0 16 16" style="color:red">
              <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
              <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
            </svg>
            <span>Without Katika</span>
          </h3>
          <p>
            Buyer sends money directly on WhatsApp.<br>
            Item arrives different or damaged.<br>
            Seller stops responding.
          </p>
        </div>

        <div class="card">
          <h3 class="scenario-title">
            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-check2-circle" viewBox="0 0 16 16" style="color:green">
              <path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0"/>
              <path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0z"/>
            </svg>
            <span>With Katika</span> 
          </h3>
          <p>
            Money is held safely.<br>
            Buyer checks the item first.<br>
            Seller is paid only after confirmation.
          </p>
        </div>
      </div>

      <!-- RIGHT: Image -->
      <div class="scenario-image">
        <img 
          src="assets/img/unsatisfied.png" 
          alt="Buyer inspecting item after online purchase"
        >
      </div>

    </div>
  </div>
</section>



<section id="cta">
  <div class="section-inner reveal" style="text-align:center">
    <h2>Stop Taking Risks When Buying Online</h2>
    <p class="section-desc">
      Join thousands of people using Katika to buy and sell safely.
    </p>

    <div class="cta">
      <a href="#" class="cta-primary">Download on Google Play</a>
      <a href="#" class="cta-secondary">Download on App Store</a>
    </div>

    <p style="margin-top:20px;font-size:14px;color:var(--muted)">
      Built for buying & selling physical goods on social media in Cameroon 🇨🇲
    </p>
  </div>
</section>



<section class="phone-showcase section-inner reveal">
  <div class="phone-text">
    <h2>See Katika in Action</h2>
    <p class="phone-desc">
      The Katika mobile app is built to make buying and selling online simple and safe.
      Every step — from payment to confirmation — is clear, guided, and easy to understand,
      even for first-time users.
    </p>
  </div>

  <div class="phone">
    <img 
      src="assets/img/katika_in_action.png" 
      alt="iPhone 17 Pro Max showing Katika app transaction protection screen"
    />
  </div>
</section>


<section id="trust">
  <div class="section-inner reveal">
    <h2>How Your Money Is Protected</h2>
    <p class="section-desc">
      These rules define how payments move inside Katika.
      They exist to protect both buyers and sellers.
    </p>

    <div class="stats">

      <div class="stat">
        <h2>100%</h2>
        <p>
          <strong>Controlled Payments</strong><br>
          Every payment is held until delivery is confirmed.
        </p>
      </div>

      <div class="stat">
        <h2>0</h2>
        <p>
          <strong>Hidden Actions</strong><br>
          No money moves without both parties knowing.
        </p>
      </div>

      <div class="stat">
        <h2>Fair</h2>
        <p>
          <strong>Dispute Handling</strong><br>
          Decisions are made using agreed rules and evidence.
        </p>
      </div>

    </div>
  </div>
</section>


<section id="download">
  <div class="section-inner reveal" style="text-align:center">
    <h2>Download Katika</h2>

    <div class="stores">
      <a href="#" class="store-badge">
        <img 
          src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" 
          alt="Download on the App Store"
        />
      </a>

      <a href="#" class="store-badge">
        <img 
          style="width: 245px; height: 99px;"
          src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png" 
          alt="Get it on Google Play"
        />
      </a>
    </div>
  </div>
</section>



<section id="faq">
  <div class="section-inner reveal">
    <h2 style="text-align:center">Frequently Asked Questions</h2>
    <p class="section-desc" style="text-align:center">
      Clear answers to common questions about using Katika safely.
    </p>

    <div class="faq-accordion">

      <div class="faq-item">
        <button class="faq-question">
          What exactly does Katika do?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            Katika helps people buy and sell physical goods online safely.
            The buyer pays through Katika, and the money is released only
            after the buyer confirms the item was received as agreed.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          Can I use Katika for WhatsApp and Facebook deals?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            Yes. If a deal starts on WhatsApp, Facebook Marketplace, Instagram,
            or Telegram, you can bring it to Katika to secure the payment.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          What happens if the seller does not deliver the item?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            If the seller does not deliver, the money is not released.
            The buyer can report the issue and the payment remains protected.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          What if the buyer receives the item but refuses to confirm?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            A dispute can be opened. Katika reviews the agreement and any
            provided evidence before deciding whether to release the money.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          Does Katika physically inspect the product?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            No. Katika does not inspect items physically.
            Decisions are based on agreed terms, delivery confirmation,
            and evidence provided by both parties.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          How long does it take for the seller to receive payment?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            Once the buyer confirms delivery, the money is released immediately.
            There is no waiting period after confirmation.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          What types of products can be sold using Katika?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            For now, Katika focuses on physical goods such as phones,
            electronics, clothes, shoes, and similar items.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          Can a transaction be cancelled?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            A transaction can be cancelled only if both parties agree
            or if delivery has not taken place and rules allow it.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          Is Katika only for big businesses?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            No. Katika is built for everyday people — individuals,
            small traders, and online sellers across Cameroon.
          </p>
        </div>
      </div>

      <div class="faq-item">
        <button class="faq-question">
          What if something goes wrong during the transaction?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            If any issue occurs, a dispute can be opened.
            Katika follows clear rules to ensure a fair outcome.
          </p>
        </div>
      </div>

    </div>
  </div>
</section>


<?php

  include "includes/footer.php" ;

?>