


<footer class="site-footer">
  <p>© <span id="year"></span> Katika. Built for trust in Cameroon.</p>

  <div class="footer-links">
    <a href="terms">Terms & Conditions</a>
    <span class="divider">•</span>
    <a href="dispute-policy">Dispute Policy</a>
    <span class="divider">•</span>
    <a href="privacy">Privacy Policy</a>
  </div>
</footer>



<script>
  document.getElementById('year').textContent = new Date().getFullYear();
</script>


<script>
  const themeToggle = document.getElementById('themeToggle');

  // Load saved theme
  const savedTheme = localStorage.getItem('theme');
  if (savedTheme === 'light') {
    document.body.classList.add('light');
    themeToggle.checked = true;
  }

  themeToggle.addEventListener('change', () => {
    document.body.classList.toggle('light', themeToggle.checked);
    localStorage.setItem(
      'theme',
      themeToggle.checked ? 'light' : 'dark'
    );
  });
</script>


<script>
  const observer = new IntersectionObserver(
    entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.classList.add('active');
        }
      });
    },
    { threshold: 0.15 }
  );

  document
    .querySelectorAll('.reveal, .reveal-left, .reveal-right, .reveal-up')
    .forEach(el => observer.observe(el));
</script>

<script>
  document.querySelectorAll('.faq-question').forEach(button => {
    button.addEventListener('click', () => {
      const item = button.parentElement;

      // Close others (optional, classy behavior)
      document.querySelectorAll('.faq-item').forEach(i => {
        if (i !== item) i.classList.remove('active');
      });

      item.classList.toggle('active');
    });
  });
</script>


<script>
  function updateLogo() {
    const logo = document.getElementById('katikaLogo');
    const isLight = document.body.classList.contains('light');
    logo.src = isLight
      ? 'assets/img/katika_logo_dark.png'
      : 'assets/img/katika_logo_light.png';
  }

  function toggleTheme() {
    document.body.classList.toggle('light');
    localStorage.setItem(
      'theme',
      document.body.classList.contains('light') ? 'light' : 'dark'
    );
    updateLogo();
  }

  // Load saved theme
  if (localStorage.getItem('theme') === 'light') {
    document.body.classList.add('light');
  }
  updateLogo();
</script>


<script>
  function toggleMenu() {
    document.getElementById('menu').classList.toggle('active');
  }
</script>


<script>
  document.querySelectorAll('#menu a').forEach(link => {
    link.addEventListener('click', () => {
      document.getElementById('menu').classList.remove('active');
    });
  });
</script>



</body>
</html>