<?php
  include "includes/header.php";
  include "includes/navigation.php";
?>

<main class="dispute-container">

  <h1>Official Dispute Resolution Policy</h1>
  <p class="dispute-subtitle">
    This policy explains how disputes are handled on the Katika platform.
    By using Katika, all users agree to follow these rules.
  </p>

  <!-- 1 -->
  <div class="dispute-section">
    <h2>1. Purpose of This Policy</h2>
    <p>
      This Dispute Resolution Policy exists to protect honest buyers and sellers,
      ensure fairness, and prevent fraud on the Katika platform.
      All disputes are resolved using clear rules and verifiable evidence,
      not emotions, pressure, or personal relationships.
    </p>
    <p class="dispute-note">
      Katika operates as a neutral escrow service and does not take sides.
    </p>
  </div>

  <!-- 2 -->
  <div class="dispute-section">
    <h2>2. What Is a Dispute?</h2>
    <p>A dispute is a formal complaint raised by a buyer when:</p>
    <ul>
      <li>The item was not delivered</li>
      <li>The item delivered is defective or damaged</li>
      <li>The item is significantly different from what was agreed</li>
      <li>The seller acted dishonestly or in bad faith</li>
    </ul>
    <p class="dispute-note">
      Disputes temporarily pause the escrow process while the issue is reviewed.
    </p>
  </div>

  <!-- 3 -->
  <div class="dispute-section">
    <h2>3. Who Can Open a Dispute</h2>
    <p>
      Only the buyer may open a dispute.
      This is because the buyer controls the release of funds.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> A seller cannot open a dispute simply because
      the buyer has not yet released funds.
    </p>
  </div>

  <!-- 4 -->
  <div class="dispute-section">
    <h2>4. Time Limit for Opening a Dispute</h2>
    <ul>
      <li>A dispute must be opened within <strong>48 hours</strong> after delivery confirmation</li>
      <li>Funds must not have been released to the seller</li>
    </ul>
    <p class="dispute-note">
      Disputes opened after this period will not be accepted.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> If delivery is confirmed on Monday at 2:00 PM,
      the buyer must open a dispute before Wednesday at 2:00 PM.
    </p>
  </div>

  <!-- 5 -->
  <div class="dispute-section">
    <h2>5. Valid Reasons for a Dispute</h2>

    <h3>5.1 Item Not Delivered</h3>
    <p>
      The seller claims to have shipped the item, but the buyer never received it
      and valid delivery proof is missing or inconsistent.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> Seller marks item as shipped but cannot provide
      a valid transport receipt or tracking confirmation.
    </p>

    <h3>5.2 Item Not as Described</h3>
    <p>
      The item delivered is materially different from the description or photos
      agreed upon at the time of escrow creation.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> Seller lists an “Original Phone Charger” but
      delivers a counterfeit or different model.
    </p>

    <h3>5.3 Item Defective or Damaged</h3>
    <p>
      The item arrives broken, unusable, or damaged during delivery.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> A blender arrives with a damaged motor and does not power on.
    </p>

    <h3>5.4 Incomplete Delivery</h3>
    <p>
      Parts, accessories, or quantities are missing from the delivery.
    </p>
    <p class="dispute-example">
      <strong>Example:</strong> Buyer orders three items but receives only one.
    </p>
  </div>

  <!-- 6 -->
  <div class="dispute-section">
    <h2>6. What Is NOT a Valid Dispute</h2>
    <ul>
      <li>Buyer changed their mind</li>
      <li>Buyer no longer wants the item</li>
      <li>Buyer found a cheaper option elsewhere</li>
      <li>Minor differences already disclosed</li>
      <li>Buyer used or damaged the item after delivery</li>
      <li>Dispute opened after the allowed time window</li>
    </ul>
    <p class="dispute-note">
      Dislike is not the same as defect.
    </p>
  </div>

  <!-- 7 -->
  <div class="dispute-section">
    <h2>7. Evidence Requirements</h2>

    <p><strong>Buyer must provide:</strong></p>
    <ul>
      <li>Clear photos or videos of the item</li>
      <li>Unboxing video (strongly recommended)</li>
      <li>Proof clearly showing the problem</li>
    </ul>

    <p style="margin-top:12px;"><strong>Seller must provide:</strong></p>
    <ul>
      <li>Original product photos</li>
      <li>Item description as listed</li>
      <li>Shipping or delivery proof</li>
    </ul>

    <p class="dispute-note">
      Claims without evidence are considered weak.
      Fake or edited evidence may result in account suspension or permanent ban.
    </p>
  </div>

  <!-- 8 -->
  <div class="dispute-section">
    <h2>8. Return of Goods Policy</h2>
    <p>
      If a refund is approved, the buyer must return the item unless explicitly stated otherwise.
    </p>
    <ul>
      <li>Buyer must ship the item back</li>
      <li>Buyer must upload shipping receipt and tracking details</li>
      <li>Item must be returned in the same condition received</li>
    </ul>
    <p class="dispute-note">
      No return = no refund.
    </p>
  </div>

  <!-- 9 -->
  <div class="dispute-section">
    <h2>9. Seller Confirmation of Returned Items</h2>
    <p>
      Sellers have <strong>48 hours</strong> to confirm receipt of returned items
      after delivery is confirmed.
    </p>
    <p>
      If the seller fails or refuses to confirm receipt, Katika will review
      delivery proof and may process the refund automatically.
    </p>
    <p class="dispute-note">
      Silence does not block refunds.
    </p>
  </div>

  <!-- 10 -->
  <div class="dispute-section">
    <h2>10. Dispute Review Process</h2>
    <ul>
      <li>Dispute is opened</li>
      <li>Escrow funds are frozen</li>
      <li>Evidence is collected from both parties</li>
      <li>Admin review based on platform rules</li>
      <li>Final decision is issued</li>
    </ul>
    <p class="dispute-note">
      Typical resolution time is 1–5 business days.
    </p>
  </div>

  <!-- 11 -->
  <div class="dispute-section">
    <h2>11. Possible Outcomes</h2>
    <ul>
      <li>Funds released to seller</li>
      <li>Funds refunded to buyer</li>
      <li>Return required before refund</li>
      <li>Partial refund (rare cases)</li>
      <li>Account warning, suspension, or ban</li>
    </ul>
    <p>
      All decisions made by Katika are final and binding.
    </p>
  </div>

  <!-- 12 -->
  <div class="dispute-section">
    <h2>12. Abuse, Lies & Fraud</h2>
    <p>
      Katika has zero tolerance for false claims, fake evidence,
      or repeated abuse of the dispute system.
    </p>
    <p class="dispute-note">
      Violators may lose disputes automatically and face permanent account bans.
    </p>
  </div>

  <!-- 13 -->
  <div class="dispute-section">
    <h2>13. Platform Authority</h2>
    <p>
      Katika reserves the right to request additional evidence,
      extend review timelines, freeze accounts under investigation,
      and reject disputes that violate this policy.
    </p>
    <p>
      Our priority is fairness, consistency, and trust.
    </p>
  </div>

</main>

<?php
  include "includes/footer.php";
?>
