<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Page Not Found | Katika</title>
  <meta name="description" content="The page you are looking for does not exist on Katika." />

  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<style>
    /* ================================
   404 PAGE
   ================================ */

.notfound-container {
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 120px 24px 60px;
}

.notfound-card {
  max-width: 520px;
  width: 100%;
  text-align: center;
  background: var(--card);
  border: 1px solid var(--border);
  border-radius: 28px;
  padding: 60px 40px;
}

.notfound-card h1 {
  font-size: 96px;
  font-weight: 900;
  background: linear-gradient(90deg, var(--blue), var(--green));
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  margin-bottom: 10px;
}

.notfound-card h2 {
  font-size: 26px;
  margin-bottom: 18px;
}

.notfound-card p {
  color: var(--muted);
  font-size: 16px;
  margin-bottom: 40px;
  line-height: 1.7;
}

.notfound-actions {
  display: flex;
  justify-content: center;
  gap: 16px;
  flex-wrap: wrap;
}

@media (max-width: 600px) {
  .notfound-card {
    padding: 48px 28px;
  }

  .notfound-card h1 {
    font-size: 72px;
  }
}


/* ================================
404 IMAGE
================================ */

.notfound-image {
  width: 100%;
  max-width: 280px;
  margin: 0 auto 28px;
  display: block;
}

/* Slightly larger on desktop */
@media (min-width: 1024px) {
  .notfound-image {
    max-width: 320px;
  }
}


</style>

<body>

  <main class="notfound-container">
    <div class="notfound-card">

      <!-- 404 IMAGE -->
      <img 
        src="assets/img/404.png"
        alt="Page not found illustration"
        class="notfound-image"
        />
        
      <h2>Page Not Found</h2>

      <p>
        The page you’re looking for doesn’t exist or may have been moved.
        Don’t worry — your money and account are still safe.
      </p>

      <div class="notfound-actions">
        <a href="./" class="cta-primary">Go to Homepage</a>
        <a href="./#faq" class="cta-secondary">Visit FAQ</a>
      </div>
    </div>
  </main>


 <?php
    include "includes/footer.php";
?>
